package de.bebagoe.util.coll;

import java.util.Arrays;

public class SimpleList {
	private Object[] elements;
	private static final int DEF_INIT_SIZE = 16;
	private int initSize;
	private int size;

	public SimpleList(int len) {
        if (len <= 0)
            throw new IllegalArgumentException("Die initiale Größe muss positiv sein.");
        initSize = len;
        elements = new Object[len];
        super();
	}
	
	public SimpleList() {
        initSize = DEF_INIT_SIZE;
        elements = new Object[DEF_INIT_SIZE];
        super();
	}
	
	public void add(Object element) {
		if (size ==  elements.length)
			elements = Arrays.copyOf(elements, elements.length + initSize);
		elements[size++] = element;
	}
	
	public Object get(int index) {
		if (index >= 0 && index < size)
			return elements[index];
		else
			return null;
	}
	
	public int size() {return size;}

	public int capacity() {return elements.length;}
}